/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.unusualfishmod.common.block_entity;

import codyhuh.unusualfishmod.common.block.VoltDetectorBlock;
import codyhuh.unusualfishmod.core.registry.UFBlockEntities;
import codyhuh.unusualfishmod.core.registry.UFBlocks;
import codyhuh.unusualfishmod.core.registry.UFTags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class VoltDetectorBlockEntity
extends BlockEntity {
    private static List<LivingEntity> anglersList = new ArrayList<LivingEntity>(5);
    private static List<LivingEntity> currentList = new ArrayList<LivingEntity>(5);

    public VoltDetectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)UFBlockEntities.VOLT_DETECTOR.get(), pos, state);
    }

    public final List<LivingEntity> getAnglerList() {
        return currentList;
    }

    public void addAnglerToList(LivingEntity obj) {
        currentList.add(obj);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, VoltDetectorBlockEntity voltDetector) {
        if (!anglersList.equals(currentList)) {
            currentList = anglersList;
        }
        double radius = 2.5;
        for (Direction dir : Direction.values()) {
            if (!level.m_8055_(pos.m_121945_(dir)).m_60713_((Block)UFBlocks.COPPER_ANTENNA.get())) continue;
            radius = 5.0;
        }
        VoltDetectorBlockEntity.nearDetector(level, pos, radius);
        int anglers = currentList.size();
        if (level.m_46832_(pos, pos) && state.m_60713_((Block)UFBlocks.VOLT_DETECTOR.get()) && !level.m_8055_(pos).m_60795_() && (Integer)level.m_8055_(pos).m_61143_((Property)VoltDetectorBlock.ANGLERS) != anglers) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)VoltDetectorBlock.ANGLERS, (Comparable)Integer.valueOf(Math.min(anglers, 5))), 3);
            ((VoltDetectorBlock)state.m_60734_()).updateNeighbours(level, pos);
        }
    }

    private static void nearDetector(Level level, BlockPos pos, double radius) {
        AABB aabb = new AABB(pos);
        currentList = level.m_6443_(LivingEntity.class, aabb.m_82400_(radius), e -> !e.m_6095_().m_204039_(UFTags.VOLT_UNDETECTED) && !e.m_6047_());
        BlockPos blockpos = new BlockPos((int)(aabb.f_82288_ - radius), (int)(aabb.f_82289_ - radius), (int)(aabb.f_82290_ - radius));
        BlockPos blockpos1 = new BlockPos((int)(aabb.f_82291_ + radius), (int)(aabb.f_82292_ + radius), (int)(aabb.f_82293_ + radius));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VoltDetectorBlockEntity) {
            VoltDetectorBlockEntity voltDetector = (VoltDetectorBlockEntity)blockEntity;
            if (level.m_46832_(blockpos, blockpos1)) {
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int i = blockpos.m_123341_(); i <= blockpos1.m_123341_(); ++i) {
                    for (int j = blockpos.m_123342_(); j <= blockpos1.m_123342_(); ++j) {
                        for (int k = blockpos.m_123343_(); k <= blockpos1.m_123343_(); ++k) {
                            mutablePos.m_122178_(i, j, k);
                            int anglers = currentList.size();
                            if (anglers >= 5) continue;
                            for (LivingEntity angler : currentList) {
                                if (currentList.contains(angler)) continue;
                                voltDetector.addAnglerToList(angler);
                            }
                        }
                    }
                }
            }
        }
    }
}

